clear all
set more off


*==============================================================
*			within and between country price dispersion
*==============================================================
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
use wf_step1001.dta, clear
capture cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"

*** note that we exclude US and Canada from this
keep if smpl2==1
drop if country=="ES"

gen ue3_rate=ue2_rate
replace ue3_rate=ue_rate if ue3_rate==. & ue_rate~=.

keep country nuts ue3_rate age_total year

compress
save temp0, replace

*** simple country mean for unemployment rate
use temp0, replace
collapse (mean) ue3_*, by(year country)
rename ue3_ cmean_uer_
save temp0_cmean, replace


*** population weighted country mean for unemployment rate
use temp0, replace
collapse (mean) ue3_rate [iw=age_total], by(year country)
rename ue3_rate cwmean_uer_
save temp0_cwmean, replace

*** simple country st.dev for unemployment rate
use temp0, replace
collapse (sd) ue3_rate, by(year country)
rename ue3_rate csd_uer_
save temp0_csd, replace

*** simple country st.dev for unemployment rate
use temp0, replace
collapse (sd) ue3_rate [iw=age_total], by(year country)
rename ue3_rate cwsd_uer_
save temp0_cwsd, replace


*** total dispersion for unemployment rate
use temp0, replace
collapse (sd) ue3_rate, by(year)
rename ue3_rate sd_uer_
gen ff=1
save temp0_sd, replace

*** total (population weighted) dispersion for unemployment rate
use temp0, replace
collapse (sd) ue3_rate [iw=age_total], by(year)
rename ue3_rate wsd_uer_
gen ff=1
save temp0_wsd, replace

*** population by country
use temp0, replace
collapse (sum) age_total, by(year country)
save temp0_age_total, replace


**** MERGE ALL FILES
**** simple average
use temp0_cmean, clear
joinby country year using temp0_csd
joinby country year using temp0_age_total
rename country region
collapse (sd) cmean_uer_ (mean) csd_uer_, by(year)
joinby year using temp0_sd
drop ff
save temp1, replace

**** population average
use temp0_cwmean, clear
joinby country year using temp0_cwsd
joinby country year using temp0_age_total
rename country region
collapse (sd) cwmean_uer_ (mean) cwsd_uer_ [iw=age_total], by(year)
joinby year using temp0_wsd
drop ff
save temp1_w, replace

**** REPORTED FIGURE
use temp1_w, clear

gen cwmean_uer_2=cwmean_uer_^2
gen cwsd_uer_2=cwsd_uer_^2
gen wsd_uer_2=wsd_uer_^2

twoway (line cwmean_uer_ year if year>=1970 & year<=1995, lcolor(red) lpattern(solid)) ///
		(line cwsd_uer_ year if year>=1970 & year<=1995, lcolor(black) lpattern(longdash)) ///
		(line wsd_uer_ year if year>=1970 & year<=1995, lcolor(blue) lpattern(shortdash)), ///
		ytitle("standard deviation" " ") xlabel(1970(5)1995) xtitle("") ///
		legend(label(1 "disp. of country means") ///
			   label(2 "within-country disp.") ///
			   label(3 "total disp.") ///
			   rows(1))
			   



